/* 
 * File:   user.h
 * Author: Wilhelm Leichtfried - C15279
 *
 * Created on July 9, 2015, 4:45 PM
 */
/*******************************************************************************
Copyright (c) 2014 released Microchip Technology Inc.  All rights reserved.

Microchip licenses to you the right to use, modify, copy and distribute
Software only when embedded on a Microchip microcontroller or digital signal
controller that is integrated into your product or third party product
(pursuant to the sublicense terms in the accompanying license agreement).

You should refer to the license agreement accompanying this Software for
additional information regarding your rights and obligations.

SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
(INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
*******************************************************************************/

#ifndef USER_H
#define	USER_H

#define MSG_ID_BUTTON_STATUS    0x200
#define MSG_ID_LED_CONTROL      0x100

void initClock(void);

void initIOPorts(void);

void OpenSPI();

void initCANport(void);

typedef union {
    struct {
        unsigned State :4;
        unsigned Changed :1;
    };
    unsigned char byte;
} ButtonState;

typedef enum {
    SX_ALL_OFF = 0x00,
    S3_POS = 0x08,
    S4_POS = 0x01,
    S5_POS = 0x02,
    S6_POS = 0x04,
    SX_ALL_ON = 0x0F
} BUTTON;

ButtonState debounceButtons();

void updateButtonLeds(ButtonState btnState);

void updateRxLeds(unsigned char *rxd);

#endif	/* USER_H */

